---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-next start

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ビルド未実行時のエラー挙動**: next-start.ts自体ではチェックしていないため、start-server.ts以降の挙動を確認すべき

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-start.ts` - next startコマンドの実装
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（363-422行目）
- E-03: `packages/next/src/server/lib/start-server.ts` - サーバー起動処理
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextStartOptionsは6つのプロパティを持つ | E-01 (26-34行目) | ○ |
| C-02 | デフォルトポートは3000 | E-02 (379-381行目) | ○ |
| C-03 | 予約ポートチェックを実行 | E-01 (49-51行目) | ○ |
| C-04 | --inspectで既存インスペクターの重複チェック | E-01 (53-75行目) | ○ |
| C-05 | inspector.open()の失敗時にprocess.exit(1) | E-01 (66-73行目) | ○ |
| C-06 | CPUプロファイルはSIGTERM/SIGINTで保存 | E-01 (77-82行目) | ○ |
| C-07 | isDev: falseでstartServerを呼び出し | E-01 (84-90行目) | ○ |
| C-08 | 子プロセスをforkしない（直接呼び出し） | E-01 (84行目) | ○ |
| C-09 | NEXT_PRIVATE_START_TIMEフォールバック設定 | E-01 (6-8行目) | ○ |
| C-10 | keepAliveTimeoutを渡す | E-01 (89行目) | ○ |
| C-11 | プロセスタイトルをnext-serverに設定 | E-03 (184行目) | ○ |
| C-12 | 関連画面なし | E-05 | ○ |
| C-13 | hostname指定なしで全インターフェースリッスン | E-01 (44行目) | ○ |
| C-14 | next devと異なりallowRetryなし | E-01 (84-90行目) | ○ |
| C-15 | CPUプロファイル保存後のプロセス終了はstart-server.ts側 | E-01 (80-81行目) | ○ |
| C-16 | ビルド未実行時にエラー表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド未実行時（.next/ディレクトリ不在）のエラーハンドリングはnext-start.ts内には直接記述されておらず、start-server.tsまたはその先の処理に依存する
  - 候補：start-server.ts / next-server.ts / router-server.tsの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: ビルド未実行エラーのハンドリング箇所がnext-start.tsの範囲外
- 0: keepAliveTimeoutのデフォルト値はNode.jsのデフォルト（5000ms）に依存

## 6) レビュアーチェックリスト（最小）
- [ ] NextStartOptionsの全パラメータが入力仕様に反映されているか
- [ ] --inspect処理のエラーハンドリングが正確か
- [ ] ビルド未実行時のエラーメッセージが実際の挙動と一致するか
- [ ] startServer呼び出し時のパラメータが正確か
